/***
* MS_Piano_dll_app: application for using MS_Piano_dll to annotate peaks in peptide MSMS spectra
* Version 1.1
* Last update on 2/16/2021
* Xiaoyu (Sara) Yang 10/25/2016
* The isotopic calculation uses Dmitrii Tchekhovskoi's program.
**/

#include "MS_Piano_dll_app.h"

int main () {
	INPUT input;
	OUTPUT output;
	int rv=0;

	input.unimod_path=_strdup ("mod_added.txt");
	input.MW_path=_strdup ("element_MW.txt");

	input.num_peaks=2;
	input.num_chars_limits=NUMCH;
	input.num_chars_error_message=NUMCHERR;
	
	input.sequence=new char[200];
	input.mods=new char[200];
	input.mz= new double[input.num_peaks];
	input.intensity= new double[input.num_peaks];
	output.error_message=new char[input.num_chars_error_message];

	output.annotation=new char*[input.num_peaks];
	for (int i=0; i<input.num_peaks; i++)
		output.annotation[i]= new char[NUMCH];

	strcpy(input.sequence, "EVCDEVR");
	input.charge=2;
	strcpy(input.mods, "2(0,E,TMT)(2,C,CAM)");
	//strcpy(input.mods, "2(0,A,TsMT)(2,D,CsAM)"); // for testing error

	input.mz[0]=403.2300;
	input.intensity[0]=298743;
	input.mz[1]=568.2838;
	input.intensity[1]=658542;

	input.tolerance=20; //ppm
	output.error_message[0]=0;
	
	rv=Peptide_annotation(&input, &output);

	if (rv==0)
		cout << output.error_message <<endl;
	else {
		for (int i=0; i<input.num_peaks; i++)
			cout << input.mz[i] << " " << input.intensity[i] << " \"" << output.annotation[i] << "\"\n";
	
		cout << "theoretical_precursor_mz:" << output.theoretical_precursor_mz <<endl;
		cout << "unassigned:" << output.unassigned <<endl;
		cout << "unassigned_all:" << output.unassigned_all <<endl;
		cout << "num_unassigned_peaks:" << output.num_unassigned_peaks <<endl;
		cout << "max_unassigned_ab:" << output.max_unassigned_ab <<endl;
		cout << "top_20_num_unassigned_peaks:" << output.top_20_num_unassigned_peaks <<endl;
	}
	
	delete input.sequence;
	delete input.mods;
	delete input.mz;
	delete input.intensity;

	for (int i=0; i<input.num_peaks; i++)
		delete output.annotation[i];
	delete output.annotation; 
	delete output.error_message;

	free (input.unimod_path);
	free (input.MW_path);

	return 1;
}
