/***
* MS_Piano_dll_app: application for using MS_Piano_dll to annotate peaks in peptide MSMS spectra
* Version 1.1
* Last update on 2/16/2021
* Xiaoyu (Sara) Yang 10/25/2016
* The isotopic calculation uses Dmitrii Tchekhovskoi's program.
**/

#define _CRT_SECURE_NO_WARNINGS 1
#define _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES 1

#include <iostream>
using namespace std;

#define NUMCH 2000 // You can change this number
#define NUMCHERR 2000 // You can change this number
#define NUMPEAKS 3000 // You can change this number

typedef struct {
	char *sequence;
	int charge;
	char *mods;
	int num_peaks;
	double *mz;
	double *intensity;
	double tolerance; //ppm
	int num_chars_limits; // number of characters for each peak annotation
	int num_chars_error_message; // number of characters for error message
	char *unimod_path;
	char *MW_path;
} INPUT; 

typedef struct {
	char **annotation;
	char *error_message;
	double theoretical_precursor_mz;
	double unassigned;
	double unassigned_all;
	int num_unassigned_peaks;
	double max_unassigned_ab;
	double top_20_num_unassigned_peaks;
} OUTPUT; 

__declspec( dllimport  ) int Peptide_annotation(const INPUT *input, OUTPUT *output);
